/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.crafting;

import dev.toma.gunsrpg.common.tileentity.SkilledWorkbenchTileEntity;
import dev.toma.gunsrpg.common.tileentity.VanillaInventoryTileEntity;
import dev.toma.gunsrpg.resource.crafting.OutputModifier;
import dev.toma.gunsrpg.resource.util.conditions.IRecipeCondition;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class SkilledRecipe<I extends SkilledWorkbenchTileEntity>
implements IRecipe<I> {
    public static final int GRID_SIZE = 3;
    private final NonNullList<Ingredient> ingredientList;
    private final List<IRecipeCondition> conditions;
    private final ItemStack output;
    private final ItemStack returningItem;
    private final ResourceLocation id;
    @Nullable
    private final OutputModifier outputModifier;
    private final int width;
    private final int height;

    protected SkilledRecipe(ResourceLocation id, int width, int height, NonNullList<Ingredient> ingredients, ItemStack output, ItemStack returningItem, OutputModifier modifier, List<IRecipeCondition> conditions) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.ingredientList = ingredients;
        this.output = output;
        this.returningItem = returningItem;
        this.outputModifier = modifier;
        this.conditions = conditions;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredientList;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean matches(I inventory, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.matchesGrid(inventory, x, y, true)) {
                    return true;
                }
                if (!this.matchesGrid(inventory, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack assemble(I inventory) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nullable
    public OutputModifier getOutputModifier() {
        return this.outputModifier;
    }

    public ItemStack getReturningItem() {
        return this.returningItem;
    }

    public Collection<IRecipeCondition> listConditions() {
        return this.conditions;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean canCraft(PlayerEntity player) {
        for (IRecipeCondition condition : this.conditions) {
            if (condition.canCraft(player)) continue;
            return false;
        }
        return true;
    }

    public List<IRecipeCondition> getFailedChecks(PlayerEntity player) {
        return this.conditions.stream().filter(condition -> !condition.canCraft(player)).collect(Collectors.toList());
    }

    private boolean matchesGrid(I inventory, int right, int top, boolean bool) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int xPos = x - right;
                int yPos = y - top;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (xPos >= 0 && yPos >= 0 && xPos < this.width && yPos < this.height) {
                    ingredient = bool ? (Ingredient)this.ingredientList.get(this.width - xPos - 1 + yPos * this.width) : (Ingredient)this.ingredientList.get(xPos + yPos * this.width);
                }
                if (ingredient.test(((VanillaInventoryTileEntity)((Object)inventory)).func_70301_a(x + y * 3))) continue;
                return false;
            }
        }
        return true;
    }
}

